function Colors(){
	var selector1 = null;
	var selector2 = null;
	var sequence1 = null;
	var sequence2 = null;
	
	this.setColor = function(id1, id2){
		if(id1 === null && typeof id1 === "object"){
			selector1 = null;
			selector2 = null;
			sequence1 = null;
			sequence2 = null;
			return;
		}
		selector1 = id1;
		selector2 = id2;
		var name1 = selector1.replace("-", "'");
		sequence1 = rnaStructure.getSequence(name1);
		if(sequence1.getPairId() === selector2 && (selector2 !== null || typeof selector2 !== "object")){
			var name2 = selector2.replace("-", "'");
			sequence2 = rnaStructure.getSequence(name2);
		}else{
			selector2 = null;
		}
	}
	
	this.randomColor = function() {
		var letters = '0123456789ABCDEF'.split('');
		var color = '#';
		for (var i = 0; i < 6; i++ ) {
			color += letters[Math.floor(Math.random() * 16)];
		}
		return color;
	}	
	
	function paint(){
		$('#color').colorPicker({
			buildCallback: function($elm) {
				$elm.prepend('<div class="cp-disp"></div>');
			},
			renderCallback: function($elm, toggled) {
				var colors = this.color.colors;				
				var hexColor = colors.HEX;
				var col = rgbLuminance(hexColor);
				$("#" + selector1).css("background-color", "#" + hexColor);
				$("#" + selector1).css("color", col);
				$("#" + selector2).css("background-color", "#" + hexColor);
				$("#" + selector2).css("color", col);
				if(selector1 !== null || typeof selector1 !== "object"){
					$(".selected").css( 'border-color', col);
					sequence1.setColor("#" + hexColor);
					rnaStructure.setColorInView(selector1, "#" + hexColor, col);
					if(sequence1.getPairId() === selector2 && (selector2 !== null || typeof selector2 !== "object")){
						sequence2.setColor("#" + hexColor);
					}
				}
			},
			animationSpeed: 250	
		});
	}
	paint();
	
	function rgbLuminance(hexcolor){
		var r = parseInt(hexcolor.substr(0,2),16);
		var g = parseInt(hexcolor.substr(2,2),16);
		var b = parseInt(hexcolor.substr(4,2),16);
		var yiq = ((r*299)+(g*587)+(b*114))/1000;
		return (yiq >= 110) ? 'black' : 'white';
	}
}